<?php

/**
 * Tenantos Generic External Provider Example
 * https://documentation.tenantos.com/Tenantos/developers-system/generic-external-provider/
 * 
 * If you don't receive the Authorization HTTP header, check your webserver configuration. 
 * https://www.google.com/search?q=php-fpm+authorization+header+missing
 * 
 * 
 * **Information about error handling:**
 *
 * - The content of "adminErrorMessage" is shown only to admins. If absent, but "userErrorMessage" is present, the content of "userErrorMessage" will be shown to admins.
 * - The content of "userErrorMessage" is shown to regular users. If absent, a generic error message is used.
 * - In cases where both error types are provided, each audience sees the relevant message.
 * - For HTTP responses outside 200-204, admins receive the raw response for troubleshooting, while users get a generic error message.
 * 
 * 
 * **Body Data Enrichment:**
 * 
 * This information is normally not needed. To cover edge cases, the body data is enriched to include meta information that aids in providing context to the request. This includes:
 * 
 * - meta.user.id: Contains the ID of the currently authenticated user, if any. This helps in associating the request with a specific user.
 * - meta.requestData: Includes the request data (GET, POST parameters, etc.) that the user submitted to Tenantos.
 * - meta.requestDetails: Offers metadata about the HTTP request itself, such as:
 *     - domain: The domain/brand where the request was triggered.
 *     - path: The path of the request, helping in identifying the endpoint being called.
 *     - method: The HTTP method used for the request (e.g., GET, POST).
 *     - ip: The IP address of the Tenantos client.
 *     - url: The full URL of the request.
 * 
 * Use `file_get_contents('php://input');` to receive the meta data, then json_decode the result. 
 * 
 * Note: If the API call is triggered by a cron job or a background job, the provided meta data may be only partially available.
 */


class api {
    private $identifier;


    public function __construct($identifier) {
        $this->identifier = $identifier;
    }


    // PUT request. No return expected
    public function setPowerOn() {
    }


    // PUT request. No return expected
    public function setPowerOff() {
    }
    
    
    // PUT request. No return expected
    public function setPowerReset() {
    }


    // PUT request. No return expected
    public function setPowerCycle() {
        $payload = file_get_contents('php://input');
        
        self::sendError([
            'adminErrorMessage' => 'Admin error message - ' . $payload,
            'userErrorMessage' => 'User error message'
        ]);
    }


    // GET request. Must return "online", "offline" or "unknown".
    public function getPowerStatus() {
        return 'online';
    }


    public static function sendError(array $errorDetails) {
        echo json_encode($errorDetails);
        exit;
    }
}


$headers = getallheaders();

if (!isset($headers['Authorization']) || $headers['Authorization'] !== 'YourBearerToken') {
    api::sendError([
        'adminErrorMessage' => 'Access token is invalid or missing.',
    ]);
}


$api = new api($_GET['identifier'] ?? '');
$action = $_GET['action'] ?? '';


if (method_exists($api, $action) && !str_contains($action, '__')) {
    $result = $api->$action();

    if (!empty($result)) {
        echo json_encode([
            'result' => $result
        ]);
    }
} else {
    api::sendError([
        'adminErrorMessage' => 'Method does not exist'
    ]);
}
